/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf.conndata;

import com.ibm.hwmca.base.rsf.BaseRsfErrorIds;
import com.ibm.hwmca.base.rsf.conndata.RetainConnectionDataManager;
import com.ibm.hwmca.base.rsf.conndata.TcpConnectionInfo;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.util.Trace;
import java.net.UnknownHostException;
import java.util.ArrayList;

public class RetainTcpConnectionInfo
implements BaseRsfErrorIds {
    private static final String TRACE_MASKT = "XCDIRCIT";
    private static final String TRACE_MASKF = "XCDIRCIF";
    private static final String TRACE_MASKD = "XCDIRCID";
    private static FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(-44, "RetTcpConInf");
    static final int ISO_COUNTRY_START = 0;
    static final int ISO_COUNTRY_END = 2;
    static final int ISO_REGION_START = 3;
    static final int ISO_REGION_END = 5;
    static final int UNIT_START = 6;
    static final int UNIT_END = 9;
    static final int NAME_START = 10;
    static final int NAME_END = 30;
    static final int IP_1_START = 31;
    static final int IP_1_END = 47;
    static final int PORT_1_START = 48;
    static final int PORT_1_END = 53;
    static final int IP_2_START = 54;
    static final int IP_2_END = 70;
    static final int PORT_2_START = 71;
    static final int PORT_2_END = 76;
    static final int ACCOUNT_START = 77;
    static final int ACCOUNT_END = 85;
    private static String cacheLocale = "";
    private static TcpConnectionInfo[] cacheValue = null;

    private RetainTcpConnectionInfo() {
        Trace.trace(TRACE_MASKT, "<> RetainTcpConnectionInfo()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TcpConnectionInfo[] getConnectionInfo(String countryAbbreviation, String regionAbbreviation) throws IllegalArgumentException, HException {
        Trace.trace(TRACE_MASKT, "-> RetainTcpConnectionInfo.getConnectionInfo() - " + countryAbbreviation + "," + regionAbbreviation);
        if (countryAbbreviation == null) {
            String msg = "Country parameter can not be null";
            IllegalArgumentException e = new IllegalArgumentException(msg);
            throw e;
        }
        String cCodeIn = countryAbbreviation.trim().toUpperCase();
        if (cCodeIn.length() != 2) {
            String msg = "Parameter >" + countryAbbreviation + "< is not a valid country abbreviation";
            IllegalArgumentException e = new IllegalArgumentException(msg);
            throw e;
        }
        String rCodeIn = null;
        rCodeIn = regionAbbreviation.equals("  ") ? regionAbbreviation : regionAbbreviation.trim().toUpperCase();
        if (!rCodeIn.equals("  ") && rCodeIn.length() != 2) {
            String msg = "Parameter >" + regionAbbreviation + "< is not a valid region abbreviation";
            IllegalArgumentException e = new IllegalArgumentException(msg);
            throw e;
        }
        String localeIn = cCodeIn + "," + rCodeIn;
        String string = cacheLocale;
        synchronized (string) {
            if (cacheLocale.equals(localeIn)) {
                TcpConnectionInfo[] newInfo = new TcpConnectionInfo[cacheValue.length];
                int i = 0;
                while (i < cacheValue.length) {
                    newInfo[i] = (TcpConnectionInfo)cacheValue[i].clone();
                    ++i;
                }
                Trace.trace(TRACE_MASKT, "<- RetainTcpConnectionInfo.getConnectionInfo() - used cached value");
                return newInfo;
            }
        }
        String[] lines = RetainConnectionDataManager.getTcpData();
        ArrayList<TcpConnectionInfo> data = new ArrayList<TcpConnectionInfo>();
        boolean found = false;
        int i = 0;
        while (i < lines.length) {
            String cCode = lines[i].substring(0, 2);
            String rCode = lines[i].substring(3, 5);
            if (localeIn.equals(cCode + "," + rCode)) {
                String port;
                String ip;
                try {
                    ip = lines[i].substring(31, 47).trim();
                    port = lines[i].substring(48, 53).trim();
                    data.add(new TcpConnectionInfo(ip, port));
                }
                catch (UnknownHostException uhe) {
                    Trace.trace(TRACE_MASKF, "<- RetainTcpConnectionInfo.getConnectionInfo() - Line = " + lines[i]);
                    new FrameworkLog(_logInfo, 57, uhe).log();
                }
                try {
                    ip = lines[i].substring(54, 70).trim();
                    port = lines[i].substring(71, 76).trim();
                    data.add(new TcpConnectionInfo(ip, port));
                }
                catch (UnknownHostException uhe) {
                    Trace.trace(TRACE_MASKF, "<- RetainTcpConnectionInfo.getConnectionInfo() - Line = " + lines[i]);
                    new FrameworkLog(_logInfo, 57, uhe).log();
                }
                found = true;
            }
            ++i;
        }
        if (!found) {
            String msg = "Country and region >" + localeIn + "< not found in database";
            IllegalArgumentException e = new IllegalArgumentException(msg);
            throw e;
        }
        TcpConnectionInfo[] newInfo = data.toArray(new TcpConnectionInfo[0]);
        String string2 = cacheLocale;
        synchronized (string2) {
            cacheLocale = localeIn;
            cacheValue = new TcpConnectionInfo[newInfo.length];
            int i2 = 0;
            while (i2 < newInfo.length) {
                RetainTcpConnectionInfo.cacheValue[i2] = (TcpConnectionInfo)newInfo[i2].clone();
                ++i2;
            }
        }
        Trace.trace(TRACE_MASKT, "<- RetainTcpConnectionInfo.getConnectionInfo()");
        return newInfo;
    }

    static void dumpCache() {
        Trace.trace(TRACE_MASKT, "-> RetainTcpConnectionInfo.dumpCache()");
        cacheLocale = "";
        cacheValue = null;
        Trace.trace(TRACE_MASKT, "<- RetainTcpConnectionInfo.dumpCache()");
    }
}

